var ConsoleWindow = ({
  x: 0,
  y: 0,
  w: GetScreenWidth(),
  h: 80,
  lines: [],
  line_amt: 5,
  current: "",
  back_color: CreateColor(0, 0, 0, 125),
  line_color: CreateColor(0, 0, 0),
  font: GetSystemFont(),
 
  // this draws the console window to the screen:
  updateBlit: function() {
    Rectangle(this.x, this.y, this.w, this.h, this.back_color);
    Rectangle(this.x, this.y+this.h, this.w, 16, this.back_color);
    OutlinedRectangle(this.x, this.y+this.h, this.w, 16, this.line_color);
 
		// draw previous lines:
    for(var i = 0; i < this.line_amt; ++i) {
      if (i < this.lines.length) {
				this.font.drawText(this.x, this.y+i*16, this.lines[i]);
			}
    } 
    
    // draw current line:   
    this.font.drawText(this.x, this.y+this.h, this.current);
 
    // draw a blinking "|" cursor:
    var time = new Date();
    if (time.getMilliseconds() > 500) {
      this.font.drawText(this.x+this.font.getStringWidth(this.current), this.y+this.h, "|");
    }
 
    this.update();
    return false;
  },
 
  // this checks for key input:
  update: function() {
    while(AreKeysLeft())
    {
       var key = GetKey();
       switch(key) {
         case KEY_ESCAPE: this.purge(); return true; break;
         case KEY_ENTER:
					 try {
						eval(this.current);
					 } catch(e) {
					  this.current = e;
					 }
           this.lines.unshift(this.current);
           this.current = "";
         break;
         case KEY_BACKSPACE: this.current = this.current.substr(0, this.current.length-1); break;
         default: this.current += GetKeyString(key, IsKeyPressed(KEY_SHIFT));
       }
    }
  },
 
  purge: function() {
    this.lines = [];
    this.current = "";
  }
});

var done = false;
while(!done) {
  // render map:
  if (IsMapEngineRunning()) RenderMap();
 
  // display console:
  done = ConsoleWindow.updateBlit();
 
  FlipScreen();
}